<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 3.2//EN">
<html>
<head>
<title>Tillv&auml;xtdiagram</title>
</head>
<body bgcolor="#FFFFc0" text="#000000" link="#0000FF" vlink=
"#000080" alink="#FF0000">
<h2>Hur Evelina v&auml;xer</h2>
<?php
# Definiera vilka filer som ska anvndas.
$indata = "tillvaxt.dat"; 
$typsnitt = '/usr/www/evelina.nygrens.info/docs/tillvaxt/arialn.ttf';
$bakgrund = 'diagrambakgrund.png';
$imagesize=getimagesize($bakgrund);
$image=ImageCreateFromPng($bakgrund);
$fd = fopen ($indata, "r");
# Frsta raden i filen innehller definition av axlarna.
# X Y1-0-8000 Y2-0-80 Y2-0-80
# betyder att varje rad i indata-filen brjar med ett X-vrde (obligatoriskt)
# Andra datavrdet p varje rad ska plottas mot vnster Y-axel (Y1) som ska
# g frn 0-8000.
# Tredje och fjrde datavrdet p varje rad ska plottas mot hger Y-axel 
# som fr vrden mellan 0 och 80. 
if (!feof ($fd)) {
  $axes = preg_split ("/[\s]+/", fgets($fd),-1,PREG_SPLIT_NO_EMPTY);
} else {
  echo "Inga data i filen.<br>";
}
# Andra raden i datafilen definierar vad det ska st p axlarna
# Datum        Vikt(g)   Lngd(cm)   Huvudomfng(cm)  Kommentar
# betyder allts x-axeln innehller datum (srivs inte ut ngonstans)
# och datavrdena som fljer r i tur och ordning vikt, lngd och huvudomfng
# Finns det fler etiketter n vad man definierat axlar ignoreras dessa bara
# det gller fr vrigt i dataserierna ocks.
if (!feof ($fd)) {
  $labels = preg_split ("/[\s]+/", fgets($fd),-1,PREG_SPLIT_NO_EMPTY); 
} else {
  echo "Inga etiketter i filen.<br>";  
} 
# Resten av datafilen r dataserierna. OBS att det r PUNKT, inte komma 
# som r decimaltecken.
# Saknas ett datavrde gr det bra att erstta med "-" s ignoreras 
# mtpunkten.
# I frsta datavrdet br dock alla vrden finnas med. Fyll p med mycket
# sm vrden om det ska inledas med noll.
if (!feof ($fd)) {
  $startpoint = preg_split ("/[\s]+/", fgets($fd),-1,PREG_SPLIT_NO_EMPTY);
} else {
  echo "Fr lite data i filen.<br>";  
} 
$xmin=strtotime($startpoint[0]);
$xmax=strtotime("now");
$white=ImageColorAllocate($image,255,255,255);
$black=ImageColorAllocate($image,0,0,0);
$red=ImageColorAllocate($image,255,0,0);
$green=ImageColorAllocate($image,0,255,0);
$blue=ImageColorAllocate($image,0,0,255);
# Frg att anvnda p axlarna
$xaxiscolor=ImageColorAllocate($image,0,0,255);
$y1axiscolor=ImageColorAllocate($image,0,0,255);
$y2axiscolor=ImageColorAllocate($image,0,0,255);
# Frg att anvnda p stdlinjerna
$netcolor=ImageColorAllocate($image,192,192,128);
# Stt frger att anvnda fr dataserierna
$color[0]=ImageColorAllocate($image,0,0,0);
$color[1]=ImageColorAllocate($image,0,0,128);
$color[2]=ImageColorAllocate($image,0,128,0);
$color[3]=ImageColorAllocate($image,128,0,0);
$color[4]=ImageColorAllocate($image,128,128,128);
$color[5]=ImageColorAllocate($image,0,128,128);
$color[6]=ImageColorAllocate($image,128,0,128);
$color[7]=ImageColorAllocate($image,192,192,128);
$xleft=50;
$xright=$imagesize[0]-40;
$ybot=80;
$ytop=$imagesize[1]-50;
$xsize=$xright-$xleft;
$ysize=$ytop-$ybot;
$xfact=($xmax-$xmin)/$xsize;

#xtics
# Skapar markeringar lngs X-axeln. Inte automatiskt val av r/mnad
# vecka och dag, utan man fr skriva om denna del av programmet.
# 86400 sekunder r ett dygn
$xtic=$xmin+86400;
while ($xtic<$xmax-1*86400) {
  $xpos=($xtic-$xmin)/$xfact+$xleft;
  # Markering fr varje dag
  # Kort streck fr markering
  #  ImageLine($image, $xpos, $imagesize[1]-$ybot, $xpos, $imagesize[1]-$ybot+5, $netcolor);
  # Lngt streck och utskrivet datum
  #    ImageLine($image, $xpos, $imagesize[1]-$ybot, $xpos, $imagesize[1]-$ytop, $netcolor);
  #    $nobox=imagettftext($image, 12, 90, $xpos+6, $imagesize[1]-($ybot-70), $color[0], $typsnitt, date('Y-m-d',$xtic));
  
  # Markering fr varje vecka (if-satsen kontrollerar om det r samma vecko-
  # dag som p frstavrdet).
  if (!strncasecmp(date('D',$xmin), date('D',$xtic), 2)) {
    ImageLine($image, $xpos, $imagesize[1]-$ybot, $xpos, $imagesize[1]-$ybot+5, $netcolor);
    # ImageLine($image, $xpos, $imagesize[1]-$ybot, $xpos, $imagesize[1]-$ytop, $netcolor);
    # $nobox=imagettftext($image, 12, 90, $xpos+6, $imagesize[1]-($ybot-70), $color[0], $typsnitt, date('Y-m-d',$xtic));
  }
  
  # Markering fr varje mnad
  if (!strncasecmp(date('d',$xmin), date('d',$xtic), 2)) {
    $xpos=($xtic-$xmin)/$xfact+$xleft;
    ImageLine($image, $xpos, $imagesize[1]-$ybot, $xpos, $imagesize[1]-$ytop, $netcolor);
    $nobox=imagettftext($image, 12, 90, $xpos+6, $imagesize[1]-($ybot-70), $color[0], $typsnitt, date('Y-m-d',$xtic));
  }
  $xtic=$xtic+86400;
}

# skapa y-axlar
for ($i=count($axes)-1;$i>=1;$i--) {
  $values=preg_split ("/-/", $axes[$i]);
  $ymin[$i]=$values[1];
  $ymax[$i]=$values[2];
  $yfact[$i]=($ymax[$i]-$ymin[$i])/$ysize;
  $y1[$i]=($startpoint[$i]-$ymin[$i])/$yfact[$i]+$ybot;
  $x1[$i]=0+$xleft;
  # Rkna fram lmplig skala p y-axlarna. Detta r lite magiskt.
  # i princip delar jag hela skalan med 10 och avrundar till en vrdesiffra.
  # blir resultatet orimligt tar jag med tv vrdesiffror (eller tv siffror
  # och ett decimaltecken)
  $yscale=round(($ymax[$i]-$ymin[$i])/10,0-strlen(intval(($ymax[$i]-$ymin[$i])/10)));
  if ($yscale==$ymax[$i]-$ymin[$i] or $yscale==0) $yscale=round(($ymax[$i]-$ymin[$i])/10,1-strlen(intval(($ymax[$i]-$ymin[$i])/10)));
  if ($yscale==$ymax[$i]-$ymin[$i] or $yscale==0) $yscale=round(($ymax[$i]-$ymin[$i])/10,2-strlen(intval(($ymax[$i]-$ymin[$i])/10)));
  # Har vi ntligen en huvudskala fr y-axeln stter vi tio delstrck.
  $yscale2=$yscale/10;
  # Stt lite variabler beroende p om det r en Y1 eller Y2-axel
  if (strncasecmp($values[0],'Y1',2)) {
    $mark=$xright+5;
    $m1=$xright;
    $m2=$xright+5;
    $scale=$xright+25;
  } else {
    $mark=$xleft-40;
    $m1=$xleft;
    $m2=$xleft-5;
    $scale=$xleft-50;
  }
  # Placering av etiketter
  $legendy=20+floor(($i - 1)/3)*20;
  $legendx=$xleft+40+120*(($i - 1) % 3);
  $tick=$ymin[$i];
  # Rita korta skalstreck
  while ($tick < $ymax[$i] and $yscale2>0) {
    $tick=$tick+$yscale2;
    $ticky=$imagesize[1]-($tick-$ymin[$i])/$yfact[$i]-$ybot;
    ImageLine($image, $m1, $ticky, $m2, $ticky, $netcolor);
  }
  $tick=$ymin[$i];
  # Rita lnga skalstreck och text
  while ($tick < $ymax[$i] and $yscale>0) {
    $tick=$tick+$yscale;
    $ticky=$imagesize[1]-($tick-$ymin[$i])/$yfact[$i]-$ybot;
    ImageLine($image, $xleft, $ticky, $xright, $ticky, $netcolor);
    $nobox=imagettftext($image, 12, 0, $mark, $ticky+6, $color[$i], $typsnitt, $tick);
  }
  # Skriv in etiketten
  $nobox=imagettftext($image, 12, 0, $legendx, $legendy, $color[$i], $typsnitt, $labels[$i]);
  # rita startpunkten
  ImageArc($image, $x1[$i], $imagesize[1]-$y1[$i], 8, 8, 0, 360,$color[$i]); 
}
# Rita resten av kurvorna s lngt det finns data-vrden
while (!feof ($fd)) {
  $buffer = preg_split ("/[\s]+/", fgets($fd),-1,PREG_SPLIT_NO_EMPTY);
  for ($i=count($axes)-1;$i>=1;$i--) {
    $y2[$i]=($buffer[$i]-$ymin[$i])/$yfact[$i]+$ybot;
    $x2[$i]=(strtotime($buffer[0])-$xmin)/$xfact+$xleft;
    if ($buffer[$i]!=0) {
      ImageLine($image, $x1[$i], $imagesize[1]-$y1[$i], $x2[$i], $imagesize[1]-$y2[$i], $color[$i]);
      ImageArc($image, $x2[$i], $imagesize[1]-$y2[$i], 8, 8, 0, 360,$color[$i]);
      $deltay[$i]=$y2[$i]-$y1[$i];
      $deltax[$i]=$x2[$i]-$x1[$i];
      $y1[$i]=$y2[$i];
      $x1[$i]=$x2[$i];
    }
  }
}
fclose ($fd);
# Rita in "prognosen" dvs extrapolera de senaste datavrdena fr varje 
# kurva.
for ($i=count($axes)-1;$i>=1;$i--) {
  if ($x1[$i] < $xright) {
    $nyx=$xright;
    $nyy=($nyx-$x1[$i])*$deltay[$i]/$deltax[$i]+$y1[$i];
    ImageLine($image, $x1[$i], $imagesize[1]-$y1[$i], $nyx, $imagesize[1]-$nyy, $red);
    ImageArc($image, $nyx, $imagesize[1]-$nyy, 8, 8, 0, 360,$red);
  }
}
$nobox=imagettftext($image, 12, 0, $xright-60, 20, $red, $typsnitt, 'Prognos');
# Y1-axel
ImageLine($image, $xleft, $imagesize[1]-$ybot, $xleft, $imagesize[1]-$ytop, $y1axiscolor);
ImageLine($image, $xleft-8, $imagesize[1]-$ytop-15, $xleft, $imagesize[1]-$ytop-30, $y1axiscolor);
ImageLine($image, $xleft, $imagesize[1]-$ytop, $xleft, $imagesize[1]-$ytop-30, $y1axiscolor);
ImageLine($image, $xleft+8, $imagesize[1]-$ytop-15, $xleft, $imagesize[1]-$ytop-30, $y1axiscolor);
$nobox=imagettftext($image, 12, 90, $xleft+6, $imagesize[1]-($ybot-70), $color[0], $typsnitt, date('Y-m-d',$xmin));
# Y2-axel
ImageLine($image, $xright, $imagesize[1]-$ybot, $xright, $imagesize[1]-$ytop, $y2axiscolor);
#ImageLine($image, $xright-8, $imagesize[1]-$ytop-15, $xright, $imagesize[1]-$ytop-30, $y2axiscolor);
#ImageLine($image, $xright, $imagesize[1]-$ytop, $xright, $imagesize[1]-$ytop-30, $y2axiscolor);
#ImageLine($image, $xright+8, $imagesize[1]-$ytop-15, $xright, $imagesize[1]-$ytop-30, $y2axiscolor);
$nobox=imagettftext($image, 12, 90, $xright+15, $imagesize[1]-($ybot-40), $color[0], $typsnitt, 'idag');
# X-axel
ImageLine($image, $xleft, $imagesize[1]-$ybot, $xright,$imagesize[1]-$ybot, $xaxiscolor);
ImageLine($image, $xright+15, $imagesize[1]-$ybot+8, $xright+30,$imagesize[1]-$ybot, $xaxiscolor);
ImageLine($image, $xright, $imagesize[1]-$ybot, $xright+30,$imagesize[1]-$ybot, $xaxiscolor);
ImageLine($image, $xright+15, $imagesize[1]-$ybot-8, $xright+30,$imagesize[1]-$ybot, $xaxiscolor);
# Hjlptexter till axlarna
$nobox=imagettftext($image, 12, 0, 10, 15, $color[0], $typsnitt, 'gram');
$nobox=imagettftext($image, 12, 0, $imagesize[0]-35, 15, $color[0], $typsnitt, 'cm');
# Lagra bilden p disken
Imagepng($image,'output.png');
#Imagejpeg($image,'output.jpeg',30);
# Inkludera bilden i HTML-sidan
?>
<img src="output.png" alt="Diagram">
</body></html>
